/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.command;

import cofh.core.command.CommandHandler;
import cofh.core.command.ISubCommand;
import cofh.core.world.TickHandlerWorld;
import cofh.lib.util.position.ChunkCoord;
import com.google.common.base.Throwables;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayDeque;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class CommandPregen
implements ISubCommand {
    public static ISubCommand instance = new CommandPregen();

    @Override
    public String getCommandName() {
        return "pregen";
    }

    @Override
    public int getPermissionLevel() {
        return 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleCommand(ICommandSender iCommandSender, String[] stringArray) {
        int n;
        int n2;
        int n3;
        if (stringArray.length < 4) {
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command.syntaxError", new Object[0]));
            throw new WrongUsageException("info.cofh.command." + this.getCommandName() + ".syntax", new Object[0]);
        }
        World world = iCommandSender.getEntityWorld();
        if (world.isRemote) {
            return;
        }
        ChunkCoordinates chunkCoordinates = null;
        int n4 = 1;
        if ("@".equals(stringArray[n4])) {
            chunkCoordinates = iCommandSender.getPlayerCoordinates();
            int n5 = ++n4;
            n3 = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[n5]);
        } else {
            try {
                n3 = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[n4++]);
            }
            catch (Throwable throwable) {
                chunkCoordinates = CommandBase.getPlayer((ICommandSender)iCommandSender, (String)stringArray[n4 - 1]).getPlayerCoordinates();
                n3 = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[n4++]);
            }
        }
        int n6 = ++n4;
        int n7 = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[n6]);
        int n8 = ++n4 + 1;
        try {
            n2 = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[n4++]);
            n = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[n4++]);
        }
        catch (Throwable throwable) {
            if (n4 > n8 || chunkCoordinates == null) {
                throw Throwables.propagate((Throwable)throwable);
            }
            --n4;
            n2 = n3;
            n = n7;
        }
        if (chunkCoordinates != null) {
            n3 = chunkCoordinates.posX / 16 - n3;
            n7 = chunkCoordinates.posZ / 16 - n7;
            n2 = chunkCoordinates.posX / 16 + n2;
            n = chunkCoordinates.posZ / 16 + n;
        }
        if (n2 < n3) {
            n8 = n3;
            n3 = n2;
            n2 = n8;
        }
        if (n < n7) {
            n8 = n7;
            n7 = n;
            n = n8;
        }
        TIntObjectHashMap<ArrayDeque<ChunkCoord>> tIntObjectHashMap = TickHandlerWorld.chunksToPreGen;
        synchronized (tIntObjectHashMap) {
            ArrayDeque<ChunkCoord> arrayDeque = (ArrayDeque<ChunkCoord>)TickHandlerWorld.chunksToPreGen.get(world.provider.dimensionId);
            if (arrayDeque == null) {
                arrayDeque = new ArrayDeque<ChunkCoord>();
            }
            for (int i = n3; i <= n2; ++i) {
                for (int j = n7; j <= n; ++j) {
                    arrayDeque.addLast(new ChunkCoord(i, j));
                }
            }
            TickHandlerWorld.chunksToPreGen.put(world.provider.dimensionId, arrayDeque);
            CommandHandler.logAdminCommand(iCommandSender, this, "info.cofh.command.pregen.start", (n2 - n3) * (n - n7), n3, n7, n2, n);
        }
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender iCommandSender, String[] stringArray) {
        if (stringArray.length == 2) {
            return CommandBase.getListOfStringsMatchingLastWord((String[])stringArray, (String[])MinecraftServer.getServer().getAllUsernames());
        }
        return null;
    }
}

